#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(t--) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li
struct Edge {
	int from, to;
	int cap,  flow;
};

vector<Edge> edges;
vector<int> g[50 * 500];
int used[50 * 500];

void add_edge(int from, int to, int cap, int flow = 0) {
	Edge e1 = {from, to, cap,  flow};
	g[from].push_back(edges.size());
	edges.push_back(e1);
	Edge e2 = {to, from, 0, -flow};
	g[to].push_back(edges.size());
	edges.push_back(e2);
}

int FLOW = 0;
int TIMER = 1;

int dfs(int v, int to) {
	
	if(v == to) {
		++FLOW;
		return true;
	}
	if(used[v] == TIMER)
		return false;
	used[v] = TIMER;
	for(int i = 0; i < g[v].size(); ++i) {
		int id = g[v][i];
		if(edges[id].flow == edges[id].cap)
			continue;
		if(dfs(edges[id].to, to)) {
			edges[id].flow += 1;
			edges[id ^ 1].flow -= 1;
			return true;
		}
	}
	return false;
}
int dfs2(int v, int to, vi& ans) {
	ans.push_back(v);
	if(v == to) {		
		return true;
	}
	for(int i = 0; i < g[v].size(); ++i) {
		int id = g[v][i];
		if(edges[id].flow <= 0)
			continue;
		if(dfs2(edges[id].to, to, ans)) {
			edges[id].flow -= 1;
			return true;
		}
	}
	return false;
}

void solve() {
	
	int n, m, k, s, t;
	cin >> n >> m >> k >> s >> t;
	--s, --t;
	vector<pi> input(m);
	for(int i = 0; i < m; ++i) {
		cin >> input[i].first >> input[i].second;
		--input[i].first, --input[i].second;
	}
	for(int day = 1;; ++day) {
		add_edge(t, t + n, 0, FLOW);
		for(int i = 0; i < n; ++i)
			add_edge(i + (day - 1) * n, i + day * n, 100000000, 0);
		t += n;
		for(int i = 0; i < m; ++i) {
			add_edge(input[i].first + n * (day - 1), input[i].second + n * day, 1, 0);
			add_edge(input[i].second+ n * (day - 1), input[i].first  + n * day, 1, 0);
		}
		vector<vector<pi>> res(day);
		++TIMER;
		while(dfs(s, t)) {
			++TIMER;
			if(FLOW == k) {
				cout << day << "\n";

				for(int i = 0; i < k; ++i) {
					vi ans;
					dfs2(s, t, ans);

					for(int pos = 0; pos + 1  < ans.size(); ++pos) {
						int cityStart = ans[pos] % n;
						int cityEnd = ans[pos + 1] % n;
						if(cityStart == cityEnd)
							continue;
						int startDay = ans[pos] / n;
						res[startDay].push_back(mp(i, cityEnd));
					}
				}

				for(int i = 0; i < res.size(); ++i) {
					cout << res[i].size() << ' ';
					for(int j = 0; j < res[i].size(); ++j) {
						cout << res[i][j].first + 1 << ' ' << res[i][j].second + 1 << " ";
					}
					cout << "\n";
				}

				return;
			}
		}
	}
}